package w83a.tld;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import n38a.exe.N38APISesion;

import org.apache.struts.util.RequestUtils;
import org.apache.struts.util.ResponseUtils;
import org.w3c.dom.Document;

import sun.misc.BASE64Encoder;
import w83a.iLote4.stubs.W83aNSHFFacadeWS;
import w83a.objects.W83aThirdPartySessionObject;
import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aUtilidadesComunes.W83AProperties;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aClsTrazas;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

public class W83aFirmarEjgvDocFeaTag extends TagSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7996836253670214207L;
	protected String msgButton;
	protected String name;
	protected String property;
	protected String propertyFirma;
	protected String mode;
	protected String tokenSeguridad;
	protected String fichBinarioBase64;
	
	public W83aFirmarEjgvDocFeaTag(){
		
		this.msgButton=null;
		this.name=null;
		this.property=null;
		this.propertyFirma=null;
		this.mode=null;
		this.tokenSeguridad=null;
		this.fichBinarioBase64=null;
	}
	
	
	
	public String getMode() {
		return mode;
	}



	public void setMode(String mode) {
		this.mode = mode;
	}



	public String getMsgButton() {
		return msgButton;
	}



	public void setMsgButton(String msgButton) {
		this.msgButton = msgButton;
	}



	public String getName() {
		return name;
	}



	public void setName(String name) {
		this.name = name;
	}



	public String getProperty() {
		return property;
	}



	public void setProperty(String property) {
		this.property = property;
	}



	public String getPropertyFirma() {
		return propertyFirma;
	}



	public void setPropertyFirma(String propertyFirma) {
		this.propertyFirma = propertyFirma;
	}



	public String getTokenSeguridad() {
		return tokenSeguridad;
	}



	public void setTokenSeguridad(String tokenSeguridad) {
		this.tokenSeguridad = tokenSeguridad;
	}


	public String getFichBinarioBase64() {
		return fichBinarioBase64;
	}



	public void setFichBinarioBase64(String fichBinarioBase64) {
		this.fichBinarioBase64 = fichBinarioBase64;
	}



	/**
	 * Implementa la ejecucin del componente visual
	 */
	public int doStartTag() throws JspException {
		try{
		StringBuffer respuesta = new StringBuffer("");
		respuesta.append("<!-- INICIO DEL COMPONENTE firmar-EJGV-FEA-->").append("\r\n");
		respuesta.append(this.importarLibrerias());
		respuesta.append(this.configurar());
		respuesta.append(this.invocar());
		respuesta.append(this.mensajeEsperarVerificacion());
		respuesta.append(this.mensajeValidacion());
		respuesta.append(this.mensajeOK());
		respuesta.append("<!-- FIN DEL COMPONENTE firmar-EJGV-FEA-->").append("\r\n");
		//code ++
		ResponseUtils.write(this.pageContext, respuesta.toString());
		}catch(JspException e){		
			throw e;	
		}catch(Exception e){		
			throw new JspException(e);	
		}
		return 0;
	}
	
	private String importarLibrerias(){
		
		return "<script src=\""+Q70ListenerUtils.getApplicationProperty("URL_COMPONENTE_FIRMA")+"\" type=\"text/javascript\"></script>";
	}
	
	private String invocar() throws Exception{
		String idioma = (String) RequestUtils.lookup(this.pageContext, this.name, W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA, null);
		String nameButton = Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","preaviso.boton.firmar",idioma);	
		
		StringBuffer response =  new StringBuffer();
		response.append("<input type='button' name='boton' value='").append(nameButton).append("' onclick=\"javascript:firmaInicio()\" class='w83aBoton'>");
		
		return response.toString();
	}

//	private String obtenerEJGVdocB64() throws JspException{
//		
//		boolean RdR= "1".equals( (String) RequestUtils.lookup(this.pageContext, "contexto", "REGISTRO_ELECTRONICO_REPERSENTANTES", null));
//		boolean redondearIB= "1".equals( (String) RequestUtils.lookup(this.pageContext, "contexto", "REORDENAR_I_B", null));
//		boolean mostrarCronograma= "1".equals( (String) RequestUtils.lookup(this.pageContext, "contexto", "MOSTRAR_CRONOGRAMA", null));
//		
//		
//		String ejgvDocNSHF="";
//		String token = (String) RequestUtils.lookup(this.pageContext, this.name, this.tokenSeguridad, null);
//		X45aCrearEjgvDocumentWS EJGVmanger = new X45aCrearEjgvDocumentWS(token);
//		HashMap hash = (HashMap) RequestUtils.lookup(this.pageContext, this.name, this.property, null);
//		X45aSolicitudObject solicitud = new X45aSolicitudObject();
//		solicitud.parseHashMap(hash);
//		try {
//			
//			ejgvDocNSHF = EJGVmanger.generarNuevoDocumento(solicitud, Q70ListenerUtils.getLanguage((HttpServletRequest) this.pageContext.getRequest()),RdR,redondearIB,mostrarCronograma);
//			String ejgvDocDecodificado=W83ABase64.decodeToString(ejgvDocNSHF);
//			ejgvDocDecodificado=ejgvDocDecodificado.replaceFirst("<div(.)*id=(\"|')firma(\"|')[^>]*>", "<div id='firma'>");
//			
//			String xmlThirdPartySession = (String) RequestUtils.lookup(this.pageContext, "contexto", "thirdPartySession", null);
//			
//			W83aThirdPartySessionObject thirdPartyObj = new W83aThirdPartySessionObject();
//			thirdPartyObj.parse(xmlThirdPartySession);
//			StringBuffer  firma = new StringBuffer();
//			firma.append(thirdPartyObj.getNombre()).append( " (").append(thirdPartyObj.getIdDocumento()).append(")");
//		
//		
//			ejgvDocDecodificado=ejgvDocDecodificado.replaceFirst("#FIRMA#",firma.toString());
//			ejgvDocNSHF=X45aBase64.encodeString(ejgvDocDecodificado);
//		} catch (X45aTramitacionWSException e1) {
//			throw new JspException(e1);
//		} catch (Exception e1) {
//			throw new JspException(e1);
//		}
//
//		return ejgvDocNSHF.replaceAll("\r\n", "");
//	}
//	
//private String obtenerEJGVdocB64FEA() throws JspException{
		
//		boolean RdR= "1".equals( (String) RequestUtils.lookup(this.pageContext, "contexto", "REGISTRO_ELECTRONICO_REPERSENTANTES", null));
//		boolean redondearIB= "1".equals( (String) RequestUtils.lookup(this.pageContext, "contexto", "REORDENAR_I_B", null));
//		boolean mostrarCronograma= "1".equals( (String) RequestUtils.lookup(this.pageContext, "contexto", "MOSTRAR_CRONOGRAMA", null));
		
		
//		String ejgvDocNSHF="";
//		String token = (String) RequestUtils.lookup(this.pageContext, this.name, this.tokenSeguridad, null);
//		X45aCrearEjgvDocumentWS EJGVmanger = new X45aCrearEjgvDocumentWS(token);
//		HashMap hash = (HashMap) RequestUtils.lookup(this.pageContext, this.name, this.property, null);
//		X45aSolicitudObject solicitud = new X45aSolicitudObject();
//		solicitud.parseHashMap(hash);
//		try {
//			
//			ejgvDocNSHF = "<?xml version='1.0' encoding='ISO-8859-1' ?><ejgvDocument><header><type>xades</type><placement>detached</placement><format>ES-T</format><signHash>null</signHash><version>2.0</version><flags>0</flags></header><body><sign>"+respuesta+"</sign></body></ejgvDocument>");
//		
//
//		} catch (Exception e1) {
//			throw new JspException(e1);
//		}
//
//		return ejgvDocNSHF.replaceAll("\r\n", "");
//	}
	
	
	private String configurar() throws Exception{
		StringBuffer response =  new StringBuffer();
		
		W83aUsuarioXLNetsBean usuarioXLNetsBean=(W83aUsuarioXLNetsBean) RequestUtils.lookup(this.pageContext, "contexto", W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO, null);
		W83aThirdPartySessionObject thirdPartyObj = new W83aThirdPartySessionObject();
		thirdPartyObj.parse(usuarioXLNetsBean.getXmlThirdPartySession());
		response.append("<script type=\"text/javascript\">").append("\r\n"); 
		if(thirdPartyObj.isJuegoDeBarcos()){
			response.append(this.configurarJuegoBarcos(thirdPartyObj));
		}else{
			response.append(this.configurarCertificado());
		}
		response.append(this.validarFirma());
		response.append("</script>").append("\r\n"); 
		response.append("<input type='hidden' name='").append(this.getPropertyFirma()).append("' id='id").append(this.getPropertyFirma()).append("'/>").append("\r\n");
		response.append("<input type='hidden' name='juegoDeBarcos' value='").append(thirdPartyObj.isJuegoDeBarcos()).append("'/>").append("\r\n");;

		return response.toString();
	}
	
	private String configurarJuegoBarcos(	W83aThirdPartySessionObject thirdPartyObj) throws Exception{
		String idioma = (String) RequestUtils.lookup(this.pageContext, this.name, W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA, null);
		String entorno=Q70ListenerUtils.getApplicationProperty("entorno_fea");
		StringBuffer response =  new StringBuffer();
		response.append("\t").append("var config = {").append("\r\n");
		response.append("\t").append("\t").append("loc : '").append(idioma).append("',").append("\r\n");
		response.append("\t").append("\t").append("pathEnviroment : '").append(entorno).append("',").append("\r\n");
		response.append("\t").append("\t").append("isHash : 'true',").append("\r\n");
		response.append("\t").append("\t").append("tipoFirma : 'detached',").append("\r\n");
		response.append("\t").append("\t").append("ref: '").append(thirdPartyObj.getRef()).append("',").append("\r\n");

		//firmar notificacion.
		W83aUsuarioXLNetsBean usuario = (W83aUsuarioXLNetsBean)RequestUtils.lookup(this.pageContext, this.name, W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO, null);
		String certificateId= "";
		if(usuario.getCodTerritorioDelegacion().equals(W83aClsConstantes.CONSTANTE_BIZKAIA)){
			certificateId= W83AProperties.getProperty("w83a", "certificateId.bizkaia");
		}else if(usuario.getCodTerritorioDelegacion().equals(W83aClsConstantes.CONSTANTE_GIPUZKOA)){
			certificateId= W83AProperties.getProperty("w83a", "certificateId.gipuzkoa");
		}else if(usuario.getCodTerritorioDelegacion().equals(W83aClsConstantes.CONSTANTE_ALAVA)){
			certificateId= W83AProperties.getProperty("w83a", "certificateId.araba");
		}else{
			certificateId= W83AProperties.getProperty("w83a", "certificateId.general");
		}
		
		response.append("\t").append("\t").append("certId: '").append(certificateId.trim()).append("',").append("\r\n");
		response.append("\t").append("\t").append("app: 'w83a',").append("\r\n");
		response.append("\t").append("\t").append("textoAFirmar : [],").append("\r\n");
		response.append("\t").append("\t").append("fResultado : function(respuesta){").append("\r\n");
		response.append("\t").append("\t").append("\t").append("if(respuesta && respuesta.length){").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\t").append("var res;").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\t").append(" do{res = respuesta.shift();}while(respuesta.length);").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\t").append("document.getElementById('").append(this.getPropertyFirma()).append("').value=res;").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("}").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("var signedData=").append("document.getElementById('").append(this.getPropertyFirma()).append("').value;");
		response.append("\t").append("\t").append("\t").append("if(signedData!='' && signedData!='error'){\r\nvalidarFirma();\r\n").append("}").append("\r\n");
		response.append("\t").append("\t").append("}").append("\r\n");
		response.append("\t").append("}").append("\r\n");
		response.append("\r\n");
		
		String documentoAFirmar=(String) RequestUtils.lookup(this.pageContext, "contexto", "ficheroBinarioBase64", null);
		W83aNSHFFacadeWS NSHFFacade = new W83aNSHFFacadeWS();
		String responseHash =NSHFFacade.createHashByteArray(getTokenXLNets("w83a"), documentoAFirmar);
		W83aClsTrazas.trazaError(null, "responseHash: "+responseHash, null);
		
		
		
		response.append("\t").append("function firmaInicio(){").append("\r\n");
		response.append("\t").append("\t").append("modificado=false;").append("\r\n"); 
		response.append("\t").append("\t").append("var eltexto = \"").append(responseHash).append("\";").append("\r\n");
		//response.append("\t").append("\t").append("var eltexto = ").append("document.getElementById('").append(this.getFichBinarioBase64()).append("').value.replace(/(\\r\\n|\\n|\\r)/gm,'')").append(";").append("\r\n"); 
		//se vuelve a setear el pathEnviroment porque el componete de firma "LO MACHACA"
		response.append("\t").append("\t").append("config.pathEnviroment = '").append(entorno).append("';").append("\r\n");
		response.append("\t").append("\t").append("config.textoAFirmar.push(eltexto);").append("\r\n");
		response.append("\t").append("\t").append("ventanaFirmaConfig(config);").append("\r\n");
		response.append("\t").append("}").append("\r\n");
		response.append("\r\n");
		return response.toString();
	}
	private String configurarCertificado() throws Exception{
		String idioma = (String) RequestUtils.lookup(this.pageContext, this.name, W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA, null);
		String entorno=Q70ListenerUtils.getApplicationProperty("entorno_fea");
		StringBuffer response =  new StringBuffer();
		response.append("\t").append("var config = {").append("\r\n");
		response.append("\t").append("\t").append("loc : '").append(idioma).append("',").append("\r\n");
		response.append("\t").append("\t").append("pathEnviroment : '").append(entorno).append("',").append("\r\n");
		response.append("\t").append("\t").append("isHash : 'true',").append("\r\n");
		response.append("\t").append("\t").append("tipoFirma : 'xades-sign-dettached',").append("\r\n");
		response.append("\t").append("\t").append("textoAFirmar : [],").append("\r\n");
		response.append("\t").append("\t").append("waitprogressdialog : false,").append("\r\n");
		response.append("\t").append("\t").append("dlgcertsel : false,").append("\r\n");
		response.append("\t").append("\t").append("dlgsign : false,").append("\r\n");
		
		response.append("\t").append("\t").append("fResultado : function(respuesta){").append("\r\n");
		response.append("\t").append("\t").append("\t").append("if(respuesta && respuesta.length){").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\t").append("var res;").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\t").append(" do{res = respuesta.shift();}while(respuesta.length);").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\t").append("document.getElementById('").append(this.getPropertyFirma()).append("').value=res;").append("\r\n");
		response.append("\t").append("\t").append("\t").append("}").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("var signedData=").append("document.getElementById('").append(this.getPropertyFirma()).append("').value;");
		response.append("\t").append("\t").append("\t").append("if(signedData!='' && signedData!='error'){\r\nvalidarFirma();\r\n").append("}").append("\r\n");
		response.append("\t").append("\t").append("}").append("\r\n");
		response.append("\t").append("}").append("\r\n");
		response.append("\r\n");
		

		String documentoAFirmar=(String) RequestUtils.lookup(this.pageContext, "contexto", "ficheroBinarioBase64", null);
		W83aNSHFFacadeWS NSHFFacade = new W83aNSHFFacadeWS();
		String responseHash =NSHFFacade.createHashByteArray(getTokenXLNets("w83a"), documentoAFirmar);
		W83aClsTrazas.trazaError(null, "responseHash: "+responseHash, null);
		
		response.append("\t").append("function firmaInicio(){").append("\r\n");
		response.append("\t").append("\t").append("modificado=false;").append("\r\n"); 
		response.append("\t").append("\t").append("var eltexto = \"").append(responseHash).append("\";").append("\r\n");
		
		//se vuelve a setear el pathEnviroment porque el componete de firma "LO MACHACA"
		response.append("\t").append("\t").append("config.pathEnviroment = '").append(entorno).append("';").append("\r\n");
		response.append("\t").append("\t").append("config.textoAFirmar.push(eltexto);").append("\r\n");
		response.append("\t").append("\t").append("ventanaFirmaConfig(config);").append("\r\n");
		response.append("\t").append("}").append("\r\n");
		response.append("\r\n");
		return response.toString();
	}

	private String validarFirma()throws Exception{
		String idioma = (String) RequestUtils.lookup(this.pageContext, this.name, W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA, null);
		StringBuffer response =  new StringBuffer();
		//response.append("<script type=\"text/javascript\">").append("\r\n"); 
		response.append("\t").append("function validarFirma(){").append("\r\n"); 
		response.append("\t").append("\t").append("mensajeEsperarVerificacion();").append("\r\n"); 
		response.append("\t").append("\t").append("var parametros = {").append("\r\n");
		response.append("\t").append("\t").append("\t").append("\"AjaxCall\" : \"true\",").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\"firma\" : document.getElementById(\"").append(this.getPropertyFirma()).append("\").value, ").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\"documentB64\" : ").append("document.getElementById('").append(this.getFichBinarioBase64()).append("').value.replace(/(\\r\\n|\\n|\\r)/gm,'') ").append("\r\n");
		response.append("\t").append("\t").append("};").append("\r\n"); 
		response.append("\r\n"); 
		response.append("\t").append("\t").append("$.ajax({").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("data:  parametros,").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("url:   'w83aValidarFirmaAJAX.do',").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("type:  'post',").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("dataType:  'html',").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("success:  function (response) {").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\t").append("tratarResultadoValidacion(response);").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("},").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("error: function(XMLHttpRequest, textStatus, errorThrown) {").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\t").append("tratarResultadoValidacion(XMLHttpRequest.responseText);").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("}").append("\r\n"); 
		response.append("\t").append("\t").append("});").append("\r\n"); 
		response.append("\t").append("}");
		response.append("\r\n"); 
		response.append("\t").append("function tratarResultadoValidacion(response){").append("\r\n"); 
		response.append("\t").append("\t").append("terminarEspera();").append("\r\n");
		response.append("\t").append("\t").append("try{").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("var trueResponse;").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("try{").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\t").append(" trueResponse = response.split(\"[AJAX_JSON]\")[1];").append("\r\n");
		response.append("\t").append("\t").append("}catch(e){").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("if(response instanceof Document){").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\t").append(" var serializer=new XMLSerializer()").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\t").append(" trueResponse = serializer.serializeToString(response).split(\"[AJAX_JSON]\")[1];").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("}").append("\r\n"); 
		response.append("\t").append("\t").append("}").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("var responseObj= jQuery.parseJSON(trueResponse);").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("if(responseObj.coincide==\"true\"){").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("alertJq();").append("\r\n");
		response.append("\t").append("\t").append("\t").append("}else{").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("\t").append("document.getElementById('").append(this.getPropertyFirma()).append("').value='';");
		response.append("\t").append("\t").append("\t").append("mensajeValidacion(responseObj.firmanteActual,responseObj.firmanteSupuesto);").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("}").append("\r\n"); 
		response.append("\t").append("\t").append("}catch(e){").append("\r\n"); 
		response.append("\t").append("\t").append("\t").append("document.getElementById('").append(this.getPropertyFirma()).append("').value='';");
		response.append("\t").append("\t").append("\t").append("alert(\""+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","firma.error.servicio",idioma)+"\" );").append("\r\n"); 
		
		response.append("\t").append("\t").append("}").append("\r\n"); 
		response.append("\t").append("}").append("\r\n"); 
		return response.toString();
	}
	
	private String mensajeValidacion()throws Exception{
		String idioma = (String) RequestUtils.lookup(this.pageContext, this.name, W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA, null);
		//CAPA
		StringBuffer  respuesta =  new StringBuffer();
		respuesta.append("\r\n").append("\r\n").append("\r\n");
		respuesta.append("\t").append("<style>").append("\r\n");
		respuesta.append("\t").append("\t").append(".ui-dialog {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append(" font-size: 100% !important;").append("\r\n");
		respuesta.append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("</style>").append("\r\n");
		respuesta.append("\t").append("<div id=\"mensajeValidacion\" style=\"display: none; text-align: left;\" >").append("\r\n");//font-size
		respuesta.append("\t").append("\t").append("\t").append("<p style=\"font-size: 14pt;\"><img  src=\"").append(Q70ListenerUtils.getApplicationProperty("PREFIJO_URL_ESTATICO")).append("/images/error-icon.png\" align=\"top\" />");
		respuesta.append("\t").append("\t").append("\t").append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","firma.invalida",idioma).toUpperCase()).append("</p>").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("<p>").append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","firmante.esperado",idioma)).append("<span id='firmanteEsperado'></span></p>").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("<p>").append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","firmante.actual",idioma)).append("<span id='firmanteActual'></span></p>").append("\r\n");
	
		respuesta.append("\t").append("</div>").append("\r\n");
		respuesta.append("\r\n").append("\r\n").append("\r\n");
		
		//CONFIGURACION
		respuesta.append("<script type=\"text/javascript\">").append("\r\n"); 
		respuesta.append("\t").append("\t").append("$(document).ready(function() {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("$(\"#mensajeValidacion\").dialog(\"close\");").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("var dialogOpts = {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("autoOpen: false,").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("modal: true,").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("buttons: {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append(" Ok: function() {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("$(\"#mensajeValidacion\").dialog(\"close\");").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("if ( navigator.userAgent.indexOf(\"MSIE 9\")>0 ){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("jQuery('.ui-widget-overlay').remove();").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("};").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("$(\"#mensajeValidacion\").dialog(dialogOpts);").append("\r\n");
		respuesta.append("\t").append("\t").append("});").append("\r\n");
		respuesta.append("\r\n").append("\r\n").append("\r\n");
		
		//LLAMADA
		respuesta.append("\t").append("\t").append("function mensajeValidacion(firmanteActual,firmanteSupuesto){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("document.getElementById('firmanteEsperado').innerHTML=firmanteSupuesto;").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("document.getElementById('firmanteActual').innerHTML=firmanteActual;").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("if ( navigator.userAgent.indexOf(\"MSIE 9\")>0 ){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("try{").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("var dialogOpts = {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("autoOpen: false,").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("modal: true,").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("buttons: {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("Ok: function() {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("$(\"#mensajeValidacion\").dialog(\"close\");").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("if ( navigator.userAgent.indexOf( \"MSIE 9\")>0 ){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("jQuery('.ui-widget-overlay').remove();").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("};").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("$(\"#mensajeValidacion\").dialog(dialogOpts);").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("}catch(e){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("$(\"#mensajeValidacion\").dialog(dialogOpts);").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"mensajeValidacion\").parentNode.style.display = 'block';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"mensajeValidacion\").parentNode.style.position = 'fixed';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"mensajeValidacion\").parentNode.style.bottom = '50%';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"mensajeValidacion\").parentNode.style.left = '0';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"mensajeValidacion\").parentNode.style.right = '0';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"mensajeValidacion\").parentNode.style.margin = 'auto';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("try{").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("$(\"#mensajeValidacion\").dialog(\"open\");").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("}catch(e){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("</script>").append("\r\n"); 
		
		return respuesta.toString();
	}
	
	
	private String mensajeOK()throws Exception{
		String idioma = (String) RequestUtils.lookup(this.pageContext, this.name, W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA, null);
		//CAPA
		StringBuffer  respuesta =  new StringBuffer();
		respuesta.append("\r\n").append("\r\n").append("\r\n");
		respuesta.append("\t").append("<style>").append("\r\n");
		respuesta.append("\t").append("\t").append(".ui-dialog {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append(" font-size: 100% !important;").append("\r\n");
		respuesta.append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("</style>").append("\r\n");
		respuesta.append("\t").append("<div id=\"jqalert\" style=\"display: none;\" >").append("\r\n");
		respuesta.append("\t").append("\t").append("<p>").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("<img  src=\"").append(Q70ListenerUtils.getApplicationProperty("PREFIJO_URL_ESTATICO")).append("/images/ok_check.png\" align=\"middle\" />").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","firma.solicitudFirmada",idioma)).append("\r\n");
		respuesta.append("\t").append("\t").append("</p>").append("\r\n");
		respuesta.append("\t").append("</div>").append("\r\n");
		respuesta.append("\r\n").append("\r\n").append("\r\n");
		
		//CONFIGURACION
		respuesta.append("<script type=\"text/javascript\">").append("\r\n"); 
		respuesta.append("\t").append("\t").append("$(document).ready(function() {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("$(\"#jqalert\").dialog(\"close\");").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("var dialogOpts = {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("autoOpen: false,").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("modal: true,").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("buttons: {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append(" Ok: function() {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("$(\"#jqalert\").dialog(\"close\");").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("if ( navigator.userAgent.indexOf(\"MSIE 9\")>0 ){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("jQuery('.ui-widget-overlay').remove();").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("$('#formLotesPreavisos').attr(\"action\",\"").append(Q70ListenerUtils.getApplicationProperty("PREFIJO_URL_DINAMICO")).append("/lotesPreavisosOP/w83afirmarDocumento.do\");").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("$('#formLotesPreavisos').submit();").append("\r\n");	
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("return false;").append("\r\n");	
		
		
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("};").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("$(\"#jqalert\").dialog(dialogOpts);").append("\r\n");
		respuesta.append("\t").append("\t").append("});").append("\r\n");
		respuesta.append("\r\n").append("\r\n").append("\r\n");
		
		//LLAMADA
		respuesta.append("\t").append("\t").append("function alertJq(){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("if ( navigator.userAgent.indexOf(\"MSIE 9\")>0 ){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("try{").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("var dialogOpts = {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("autoOpen: false,").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("modal: true,").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("buttons: {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("Ok: function() {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("$(\"#jqalert\").dialog(\"close\");").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("if ( navigator.userAgent.indexOf( \"MSIE 9\")>0 ){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("jQuery('.ui-widget-overlay').remove();").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("};").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("$(\"#jqalert\").dialog(dialogOpts);").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("}catch(e){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("$(\"#jqalert\").dialog(dialogOpts);").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"jqalert\").parentNode.style.display = 'block';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"jqalert\").parentNode.style.position = 'fixed';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"jqalert\").parentNode.style.bottom = '50%';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"jqalert\").parentNode.style.left = '0';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"jqalert\").parentNode.style.right = '0';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"jqalert\").parentNode.style.margin = 'auto';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("try{").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("$(\"#jqalert\").dialog(\"open\");").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("}catch(e){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("</script>").append("\r\n"); 
		
		return respuesta.toString();
	}
	
	
private String mensajeEsperarVerificacion() throws Exception{
		String idioma = (String) RequestUtils.lookup(this.pageContext, this.name, W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA, null);
		//CAPA
		StringBuffer  respuesta =  new StringBuffer();
		respuesta.append("\r\n").append("\r\n").append("\r\n");
		respuesta.append("\t").append("<style>").append("\r\n");
		respuesta.append("\t").append("\t").append(".ui-dialog {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append(" font-size: 100% !important;").append("\r\n");
		respuesta.append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("</style>").append("\r\n");
		respuesta.append("\t").append("<div id=\"esperaVerificacion\" style=\"display: none;\" >").append("\r\n");	
		respuesta.append("\t").append("\t").append("\t").append("<p>").append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","firma.esperar.1",idioma)).append("</p>").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("<p>").append("<img  src=\"").append(Q70ListenerUtils.getApplicationProperty("PREFIJO_URL_ESTATICO")).append("/images/cargandoInfo.gif\" align=\"middle\" />").append("</p>").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("<p>").append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","firma.esperar.2",idioma)).append("</p>").append("\r\n");
		respuesta.append("\t").append("</div>").append("\r\n");
		respuesta.append("\r\n").append("\r\n").append("\r\n");
		
		//CONFIGURACION
		respuesta.append("<script type=\"text/javascript\">").append("\r\n"); 
		respuesta.append("\t").append("\t").append("$(document).ready(function() {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("$(\"#esperaVerificacion\").dialog(\"close\");").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("var dialogOpts = {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("autoOpen: false,").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("modal: true").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("};").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("$(\"#esperaVerificacion\").dialog(dialogOpts);").append("\r\n");
		respuesta.append("\t").append("\t").append("});").append("\r\n");
		respuesta.append("\r\n").append("\r\n").append("\r\n");
		
		//LLAMADA
		respuesta.append("\t").append("\t").append("function mensajeEsperarVerificacion(){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("if ( navigator.userAgent.indexOf(\"MSIE 9\")>0 ){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("try{").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("var dialogOpts = {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("autoOpen: false,").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("modal: true,").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("buttons: {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("Ok: function() {").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("$(\"#esperaVerificacion\").dialog(\"close\");").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("if ( navigator.userAgent.indexOf( \"MSIE 9\")>0 ){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("jQuery('.ui-widget-overlay').remove();").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("};").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("$(\"#esperaVerificacion\").dialog(dialogOpts);").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("}catch(e){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("\t").append("$(\"#esperaVerificacion\").dialog(dialogOpts);").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"esperaVerificacion\").parentNode.style.display = 'block';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"esperaVerificacion\").parentNode.style.position = 'fixed';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"esperaVerificacion\").parentNode.style.bottom = '50%';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"esperaVerificacion\").parentNode.style.left = '0';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"esperaVerificacion\").parentNode.style.right = '0';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("document.getElementById(\"esperaVerificacion\").parentNode.style.margin = 'auto';").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("try{").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("$(\"#esperaVerificacion\").dialog(\"open\");").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("}catch(e){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\r\n").append("\r\n").append("\r\n");
		
		
		respuesta.append("\t").append("\t").append("function terminarEspera(){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("$(\"#esperaVerificacion\").dialog(\"close\");").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("if ( navigator.userAgent.indexOf(\"MSIE 9\")>0 ){").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("\t").append("jQuery('.ui-widget-overlay').remove();").append("\r\n");
		respuesta.append("\t").append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("\t").append("\t").append("}").append("\r\n");
		respuesta.append("</script>").append("\r\n"); 
		
		return respuesta.toString();
	}
	
	
	
	public static String getTokenXLNets (String idAplic){
	  String token = null;
	 
	  try {
	    N38APISesion miAPISesion = new N38APISesion();
	    Document miSesion;
	    miSesion=miAPISesion.n38APISesionCrearApp(idAplic);
	    token = DOM2String(miSesion);

	  } catch (Exception e){
		  
		  token= leerFichero("c:/config/p16b/Tokenw83a.txt", false);
		  
	   W83aClsTrazas.trazaDebug(null, "P16BPlateaUtils->getTokenXLNets: Excepcion creando el token de aplicacion");
	   e.printStackTrace();
	  }
	 
	  return token;
	}

	
	/**
	 * Lee un fichero y devuelve el contenido
	 * @param elFichero el nombre del fichero
	 * @param codificar indica si ha de codificarse el contenido 
	 * @return el contenido
	 */
	public static String leerFichero(String elFichero, boolean codificar){
		String cadenaSesion= "";
		try {
			File laSesion= new File(elFichero);
			
			InputStream is = new FileInputStream(laSesion);
		    
	        long length = laSesion.length();
		    
	        // Create the byte array to hold the data
	        byte[] bytes = new byte[(int) length];
		    
		    // Read in the bytes
		    int offset = 0;
		    int numRead = 0;
		    while (offset < bytes.length
		    		&& (numRead=is.read(bytes, offset, bytes.length - offset)) >= 0) {
		    	offset += numRead;
	        }

	        // Ensure all the bytes have been read in
	        if (offset < bytes.length) {
	            throw new IOException("No se ha podido leer " + elFichero);
	        }

	        // Close the input stream and return bytes
	        is.close();

	        BASE64Encoder encoder = new BASE64Encoder();

	        if (codificar) {
	            cadenaSesion = encoder.encode(bytes);
	        } else {
	            cadenaSesion = new String(bytes);
	        }

		} catch (Exception e) {
			W83aClsTrazas.trazaDebug(null, "P16BPlateaUtils.leerFichero->EXCEPTION");
		}

		return cadenaSesion;
	}

	public static String DOM2String(Document doc)
	{
		TransformerFactory transformerFactory =TransformerFactory.newInstance();
		Transformer transformer = null;
		try{
			transformer = transformerFactory.newTransformer();
		}catch (javax.xml.transform.TransformerConfigurationException error){
			//int coderror=123;
			//String msgerror=error.getMessage();
			return null;
		}
		 
		Source source = new DOMSource(doc);
		 
		StringWriter writer = new StringWriter();
		Result result = new StreamResult(writer);
		try{
			transformer.transform(source,result);
		}catch (javax.xml.transform.TransformerException error){
			//int coderror=123;
			//String msgerror=error.getMessage();
			return null;
		}
		 
		String s = writer.toString();
		return s;//NOPMD
	}
}
